﻿//////////////////////////////////////////////
// Rectangle.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkWinUi
#include "../Dll/DllDefines.h"

#include "Point.h"

/// Class ------------------------------------

namespace nkMaths
{	
	class DLL_MATHS_EXPORT Rectangle final
	{
		public :

			// Functions
			// Constructor, destructor
			Rectangle () noexcept ;
			Rectangle (float x, float y, float width, float height) noexcept ;

			// Utilities
			bool pointInside (Point point) const ;

			// Operators
			Rectangle operator+ (const Rectangle& other) const ;

		public :

			// Attributes
			float _x ;
			float _y ;
			float _width ;
			float _height ;
	} ;
}